"use client"

import { DialogDescription, DialogHeader, DialogTitle } from "@/components/ui/dialog";
import { InputCopy } from "@/components/ui/input.copy";
import { ScrollArea } from "@/components/ui/scroll-area";
import { Separator } from "@/components/ui/separator";
import { TransformedAgency } from "@/types/transformers";
import { ComponentWithClassName } from "@/types/utils";
import { potentialDateToDateStringFormatter } from "@/lib/formatters/date-formatter";
import { StatusRevalidateBannerForAgency } from "./status.revalidate-banner-for-agency";

export function WorkflowDialogStatus({ data, className }: ComponentWithClassName<{ data: NonNullable<TransformedAgency> }>) {
  if (data.access !== "ALL") {
    return;
  }
  const { dates, gtfsId } = data
  return (
    <>
      <DialogHeader className={className}>
        <DialogTitle>Feed status</DialogTitle>
        <DialogDescription>Currently viewing status information for &apos;<span className="font-mono font-bold">{data.name}</span>&apos;.</DialogDescription>
      </DialogHeader>

      <StatusRevalidateBannerForAgency agency={gtfsId} delay={0.25} />

      <ScrollArea className="h-fit w-full pr-3">
        <div className="grid max-h-96 flex-col gap-4 pb-12">
          <InputCopy defaultValue={`${data.path}.gtfs.zip`} label="File name" />

          {INTERNAL_getUploadedDateInputs({
            uploaded: dates.uploaded,
            statusLabel: "Files uploaded to server",
            dateLabel: "Last uploaded files to server"
          })}


          {INTERNAL_getUploadedDateInputs({
            uploaded: dates.uploadedToPreview,
            statusLabel: "Uploaded to preview environment",
            dateLabel: "Last uploaded to preview environment"
          })}

          <Separator className="w-[calc(100%-1rem)] justify-self-center my-2" />

          {INTERNAL_getUploadedDateInputs({
            uploaded: dates.uploadedToLive,
            statusLabel: "Uploaded to live environment",
            dateLabel: "Last uploaded to live environment"
          })}
        </div>
      </ScrollArea>
    </>
  )
}

function INTERNAL_getUploadedDateInputs({
  uploaded,
  statusLabel,
  dateLabel
}: {
  uploaded: Date | undefined,
  statusLabel: string,
  dateLabel: string,
}) {
  if (!uploaded) {
    return (
      <div className="grid md:justify-center md:grid-cols-2 gap-2">
        <InputCopy
          className={"text-destructive"}
          defaultValue={"Not uploaded"}
          label={statusLabel}
        />

        <InputCopy
          defaultValue={potentialDateToDateStringFormatter(uploaded)}
          label={dateLabel}
        />
      </div>
    )
  }

  return (
    <div className="grid md:justify-center md:grid-cols-2 gap-2">
      <InputCopy
        className={"text-green-500 dark:text-green-600"}
        defaultValue={"Success"}
        label={statusLabel} />

      <InputCopy
        defaultValue={potentialDateToDateStringFormatter(uploaded)}
        label={dateLabel}
      />
    </div>
  )
}
